<?php

namespace FiloBlu\Flow\Model\Filters;

/**
 * Class Multiselect
 * @package FiloBlu\Flow\Model\Filters
 */
class Multiselect extends AbstractFilter
{

    /**
     * @param $value
     * @param $args
     * @return array|string|string[]
     */
    public function filter($value, $args)
    {
        $v = trim($value ?? '');

        if ($args && count($args)) {
            foreach ($args as $key => $val) {
                if ($key === 'separator') {
                    return str_replace($val, ',', $v);
                }
            }
        }
        return $v;
    }

}
