<?php
declare(strict_types=1);

namespace FiloBlu\Flow\Model\Filters;

use FiloBlu\Flow\Helper\ProductLookupHelper;

/**
 * Class EanToSkuConverter
 * @package FiloBlu\Flow\Model\Filters
 */
class EanToSkuConverter extends AbstractFilter
{

    /**
     * @var ProductLookupHelper
     */
    private $productLookupHelper;

    /**
     * @param ProductLookupHelper $productLookupHelper
     */
    public function __construct(ProductLookupHelper $productLookupHelper)
    {
        $this->productLookupHelper = $productLookupHelper;
    }

    /**
     * @param $value
     * @param $args
     * @return string
     */
    public function filter($value, $args)
    {
        $ean = trim($value ?? '');

        $sku = $this->productLookupHelper->getSkuFromAttributeCode('ean', $ean);

        if (!$sku) {
            $sku = "ean_{$ean}_missing";
        }

        return $sku;
    }
}
