<?php
declare(strict_types=1);

namespace FiloBlu\Flow\Model\Filters;

use FiloBlu\Flow\Helper\ProductLookupHelper;

/**
 * Class BarcodeToSkuConverter
 * @package FiloBlu\Flow\Model\Filters
 */
class BarcodeToSkuConverter extends AbstractFilter
{
    /**
     * @var ProductLookupHelper
     */
    private $productLookupHelper;

    /**
     * @param ProductLookupHelper $productLookupHelper
     */
    public function __construct(ProductLookupHelper $productLookupHelper)
    {
        $this->productLookupHelper = $productLookupHelper;
    }

    /**
     * @param $value
     * @param $args
     * @return string
     */
    public function filter($value, $args)
    {
        $barcode = trim($value ?? '');

        $sku = $this->productLookupHelper->getSkuFromAttributeCode('barcode', $barcode);

        if (!$sku) {
            $sku = "barcode_{$barcode}_missing";
        }

        return $sku;
    }
}
