<?php

namespace FiloBlu\Flow\Model;

use Exception;
use FiloBlu\Flow\Api\DocumentInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * Class Document
 * @package FiloBlu\Flow\Model
 */
class Document extends AbstractModel implements DocumentInterface
{
    /**
     * @return void
     */
    public function _construct()
    {
        $this->_init(ResourceModel\Document::class);
    }

    /**
     * @return int|mixed
     */
    public function getId() {
        return $this->getData('id');
    }

    /**
     * @param mixed $id
     * @return AbstractModel|mixed
     */
    public function setId($id) {
        $this->setData('id',$id);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getName() {
        return $this->getData('name');
    }

    /**
     * @param $name
     * @return mixed
     */
    public function setName($name) {
        $this->setData('name',$name);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getMime() {
        return $this->getData('mime');
    }

    /**
     * @param $mime
     * @return mixed
     */
    public function setMime($mime) {
        $this->setData('mime',$mime);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getSource() {
        return $this->getData('source');
    }

    /**
     * @param $source
     * @return mixed
     */
    public function setSource($source) {
        $this->setData('source',$source);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getDestination() {
        return $this->getData('destination');
    }

    /**
     * @param $destination
     * @return mixed
     */
    public function setDestination($destination) {
        $this->setData('destination',$destination);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getStatus() {
        return $this->getData('status');
    }

    /**
     * @param $status
     * @return mixed
     */
    public function setStatus($status) {
        $this->setData('status',$status);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getMetaFile()
    {
        return $this->getData('meta_file');
    }

    /**
     * @param $file
     * @return mixed
     */
    public function setMetaFile($file)
    {
        $this->setData('meta_file', $file);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getMetaInsertTime()
    {
        return $this->getData('meta_insert_time');
    }

    /**
     * @param $time
     * @return mixed
     */
    public function setMetaInsertTime($time)
    {
        $this->setData('meta_insert_time', $time);
    }

    /**
     * @return mixed
     */
    public function getMetaProcessed()
    {
        return $this->getData('meta_processed');
    }

    /**
     * @param $meta_processed
     * @return mixed
     */
    public function setMetaProcessed($meta_processed)
    {
        $this->setData('meta_processed', $meta_processed);
        return $this->getData();
    }

}
