<?php

namespace FiloBlu\Flow\Model\Channel\In;


use Exception;
use FiloBlu\Flow\Helper\Data;
use FiloBlu\Flow\Helper\LoggerProvider;
use FiloBlu\Flow\Helper\SwatchColor as SwatchColorHelper;
use FiloBlu\Flow\Model\Channel\ConfigFactory;
use FiloBlu\Flow\Model\InboundflowFactory;
use FiloBlu\Flow\Model\SwatchColorFactory;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\DB\Adapter\AdapterInterface;
use Magento\Framework\ObjectManagerInterface;
use Monolog\Logger;

/**
 * Class SwatchImage
 * @package FiloBlu\Flow\Model\Channel\In
 */
class Swatchcolor extends AbstractModel
{
    /**
     * @var Logger
     */
    protected $_logger;

    /**
     * @var array
     */
    protected $_storesByLocale = [];

    /**
     * @var Data
     */
    protected $_helper;

    /**
     * @var ObjectManagerInterface
     */
    protected $objectManager;

    /**
     * @var array
     */
    protected $_specialActionProperties = [];

    /**
     * @var ResourceConnection
     */
    protected $resourceConnection;

    /**
     * @var array
     */
    protected $_storeByLocale;

    /**
     * @var InboundflowFactory
     */
    protected $inboundFlowFactory;
    /**
     * @var SwatchColorHelper
     */
    private $swatchColorHelper;
    /**
     * @var SwatchColorFactory
     */
    private $swatchColorFactory;

    /**
     * Anagrafica constructor.
     * @param LoggerProvider $loggerProvider
     * @param ConfigFactory $channelConfigFactory
     * @param ResourceConnection $resourceConnection
     * @param Data $helper
     * @param InboundflowFactory $inboundFlowFactory
     * @param ObjectManagerInterface $objectManager
     * @param SwatchColorHelper $swatchColorHelper
     * @param SwatchColorFactory $swatchColorFactory
     */
    public function __construct(
        LoggerProvider $loggerProvider,
        ConfigFactory $channelConfigFactory,
        ResourceConnection $resourceConnection,
        Data $helper,
        InboundflowFactory $inboundFlowFactory,
        ObjectManagerInterface $objectManager,
        SwatchColorHelper $swatchColorHelper,
        SwatchColorFactory $swatchColorFactory
    ) {
        parent::__construct($loggerProvider, $channelConfigFactory, $objectManager);
        $this->resourceConnection = $resourceConnection;
        $this->_helper = $helper;
        $this->_storeByLocale = $helper->getAllStoresCodeByLocale();
        $this->inboundFlowFactory = $inboundFlowFactory;
        $this->swatchColorHelper = $swatchColorHelper;
        $this->swatchColorFactory = $swatchColorFactory;
    }

    /**
     * @param $channelName
     * @return AbstractModel
     * @throws Exception
     */
    public function load($channelName)
    {
        $this->_specialActionProperties = $this->_helper->getSpecialActionsPriorities();
        return parent::load($channelName);
    }

    /**
     * @param $row
     * @return bool|void
     * @throws Exception
     */
    public function insertData($row)
    {
        $meta_file = $this->getFile()->getId();

        $optionIds = $this->swatchColorHelper->getOptionIdsByValue($row['option_name'], $row['attribute']);

        foreach ($optionIds as $optionId) {
            $bind = [
                'attribute'        => $row['attribute'],
                'option_name'       => $row['option_name'] ,
                'value'            => $row['value'],
                'option_id'        => $optionId,
                'type'             => 1,
                'meta_file'        => $meta_file,
                'meta_ref_id'      => 0,
                'meta_processed'   => 0,
                'meta_insert_time' => date('Y-m-d H:i:s')
            ];

            $swatchColor = $this->swatchColorFactory->create();
            $swatchColor->setData($bind);
            try {
                $swatchColor->save();
            } catch (Exception $e) {
                $this->_logger->error('Error saving swatch color: ' . $e->getMessage());
            }
        }
    }

    /**
     * Receive file from remote source.
     *
     * Affected by following options
     * - Copy to Ite
     *
     *
     * @param $file
     * @return mixed
     * @throws Exception
     */
    public function receiveFile($file)
    {
        if (!$this->_connector) {
            throw new Exception('No connector joined to channel');
        }

        $received = $this->_connector->receiveResource($file->getName());

        if (!$received) {
            throw new Exception('No remote files found');
        }

        return $received;
    }

}
