<?php

namespace FiloBlu\Flow\Model\AmastyMultiInventory;

use Magento\Framework\Module\Manager;
use Magento\Framework\ObjectManagerInterface;

/**
 * Class FullFactory
 * @package FiloBlu\Flow\Model\AmastyMultiInventory
 */
class FullFactory
{
    /**
     * @var Manager
     */
    protected $moduleManager;
    /**
     * @var ObjectManagerInterface
     */
    protected $objectManager;

    /**
     * FullFactory constructor.
     * @param Manager $moduleManager
     * @param ObjectManagerInterface $objectManager
     */
    public function __construct(
        Manager $moduleManager,
        ObjectManagerInterface $objectManager
    ) {
        $this->moduleManager = $moduleManager;
        $this->objectManager = $objectManager;
    }

    /**
     * @param array $data
     * @param null $className
     * @return mixed|null
     */
    public function create(array $data = [], $className = null)
    {
        if (!$className) {
            return null;
        }

        $instanceName = null;
        if ($this->moduleManager->isEnabled('Amasty_MultiInventory')) {
            $instanceName = $className;
        }

        if ($instanceName) {
            return $this->objectManager->create($instanceName, $data);
        }

        return $instanceName;
    }
}
