<?php

namespace FiloBlu\Flow\Model\Actions\From;

use \Magento\Catalog\Model\Product\Link;
use Magento\ConfigurableProduct\Model\ResourceModel\Product\Type\ConfigurableFactory;
use Magento\Framework\App\ResourceConnection;

/**
 * Class Removeallcosssell
 * @package FiloBlu\Flow\Model\Actions\From
 */
class Removeallcrosssell extends AbstractAddLink
{

    /**
     * @return int of \Magento\Catalog\Model\Product\Link::LINK_TYPE_RELATED, \Magento\Catalog\Model\Product\Link::LINK_TYPE_CROSSSELL, \Magento\Catalog\Model\Product\Link::LINK_TYPE_UPSELL
     */
    protected function getLinkType()
    {
        return Link::LINK_TYPE_CROSSSELL;
    }

    public function process($product, $value, $storeId)
    {
        $products = $this->getTargetProducts($product);
        foreach ($products as $productId) {
            $this->deleteLinkEntries($productId, $this->getLinkType());
        }
    }

}
