<?php

namespace FiloBlu\Flow\Cron;

use Exception;
use FiloBlu\Flow\Helper\LoggerProvider;
use FiloBlu\Flow\Model\Processor;
use FiloBlu\Flow\Model\ProcessorFactory;
use Monolog\Logger;

/**
 * Class Fetch
 * @package FiloBlu\Flow\Cron
 */
class Fetch
{
    /**
     * @var Processor
     */
    protected $_processor;
    /***
     * @var ProcessorFactory
     */
    protected $processorFactory;

    /**
     * @var Logger
     */
    protected $logger;
    /**
     * @var
     */
    protected $old_wait_timeout;
    /**
     * @var
     */
    protected $old_interactive_timeout;
    /**
     * to prevent 'General error: 2006 MySQL server has gone away ' error.
     */
    protected $new_wait_value_timeout = 600; //10 Minutes

    /**
     * Fetch constructor.
     * @param LoggerProvider $loggerProvider
     * @param ProcessorFactory $processorFactory
     */
    public function __construct(
        LoggerProvider $loggerProvider,
        ProcessorFactory $processorFactory
    ) {
        $this->logger = $loggerProvider->getLogger();
        $this->processorFactory = $processorFactory;
    }

    /**
     * @return $this
     * @throws Exception
     */
    public function execute()
    {
        $this->logger->info(__METHOD__);
        $this->getProcessor()->fetchChannels();
        return $this;
    }

    /**
     * @return Processor
     */
    protected function getProcessor()
    {
        if ($this->_processor === null) {
            $this->_processor = $this->processorFactory->create();
        }

        return $this->_processor;
    }

    /**
     * @return $this
     * @throws Exception
     */
    public function executeBus1()
    {
        $this->logger->info(__METHOD__);
        $this->getProcessor()->fetchChannels(1);
        return $this;
    }

    /**
     * @return $this
     * @throws Exception
     */
    public function executeBus2()
    {
        $this->logger->info(__METHOD__);
        $this->getProcessor()->fetchChannels(2);
        return $this;
    }

    /**
     * @return $this
     * @throws Exception
     */
    public function executeBus3()
    {
        $this->logger->info(__METHOD__);
        $this->getProcessor()->fetchChannels(3);
        return $this;
    }

    /**
     * @return $this
     * @throws Exception
     */
    public function executeBus4()
    {
        $this->logger->info(__METHOD__);
        $this->getProcessor()->fetchChannels(4);
        return $this;
    }

    /**
     * @return $this
     * @throws Exception
     */
    public function receive()
    {
        $this->logger->info(__METHOD__);
        $this->getProcessor()->receiveData();
        return $this;
    }

    /**
     * @return $this
     * @throws Exception
     */
    public function parse()
    {
        $this->logger->info(__METHOD__);
        $this->getProcessor()->parse();
        return $this;
    }

    /**
     * @return $this
     * @throws Exception
     */
    public function process()
    {
        $this->logger->info(__METHOD__);
        $this->getProcessor()->process();
        return $this;
    }

    /**
     * @return $this
     * @throws Exception
     */
    public function processCritical()
    {
        $this->logger->info(__METHOD__);
        $this->getProcessor()->processCritical();
        return $this;
    }

    /**
     * @return $this
     * @throws Exception
     */
    public function clean()
    {
        $this->logger->info(__METHOD__);
        $this->getProcessor()->clean();
        return $this;
    }
}
