<?php

namespace FiloBlu\Flow\Controller\Adminhtml\Inboundflow;
use Exception;
use Magento\Backend\App\Action;
use Magento\Framework\View\Result\PageFactory;

/**
 * Class MassDelete
 * @package FiloBlu\Flow\Controller\Adminhtml\Inboundflow
 */
class MassDelete extends Action
{
    /**
     * @var PageFactory
     */
    public function execute()
    {

        $ids = $this->getRequest()->getParam('id');
        if (!is_array($ids) || empty($ids)) {
            $this->messageManager->addErrorMessage(__('Please select product(s).'));
        } else {
            try {
                foreach ($ids as $id) {
                    $row = $this->_objectManager->get('FiloBlu\Flow\Model\Inboundflow')->load($id);
                    $row->delete();
                }
                $this->messageManager->addSuccessMessage(
                    __('A total of %1 record(s) have been deleted.', count($ids))
                );
            } catch (Exception $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
            }
        }
        $this->_redirect('*/*/');
    }
}
