<?php

namespace FiloBlu\Flow\Controller\Adminhtml\Inboundflow;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Page;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\View\Result\Layout;
use Magento\Framework\View\Result\LayoutFactory;

/**
 * Class Grid
 * @package FiloBlu\Flow\Controller\Adminhtml\Inboundflow
 */
class Grid extends Action
{
    /**
     * @var Page
     */
    protected $resultPage;

    /**
     * @var LayoutFactory
     */
    protected $resultLayoutFactory;

    /**
     * Grid constructor.
     * @param Context $context
     * @param LayoutFactory $resultLayoutFactory
     */
    public function __construct(
        Context $context,
        LayoutFactory $resultLayoutFactory
    ) {
        parent::__construct($context);
        $this->resultLayoutFactory = $resultLayoutFactory;
    }

    /**
     * @return ResponseInterface|ResultInterface|Layout
     */
    public function execute()
    {
        $resultLayout = $this->resultLayoutFactory->create();
        $resultLayout->getLayout()->getBlock('flow_inboundflow_grid');
        return $resultLayout;
    }
}
