<?php
namespace FiloBlu\Flow\Controller\Adminhtml\Check;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use FiloBlu\Flow\Helper\Check;

/**
 * Class Checkcsv
 * @package FiloBlu\Flow\Controller\Adminhtml\Check
 */
class Checkcsv extends Action
{
    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    protected $resultPageFactory;

    /**
     * @var \Magento\Backend\Model\View\Result\Page
     */
    protected $resultPage;

    /**
     * @var \FiloBlu\Flow\Model\Processor
     */
    protected $_processor;

    /**
     * @var FiloBlu\Flow\Helper\Check
     */
    protected $_check;

    /**
     * @var \FiloBlu\Flow\Model\Map
     */
    protected $_map;

    /**
     * @var
     */
    protected $_registry;

    /**
     * Checkcsv constructor.
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param \FiloBlu\Flow\Model\Processor $processor
     * @param \FiloBlu\Flow\Model\Map $map
     * @param Check $check
     * @param \Magento\Framework\Registry $registry
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        \FiloBlu\Flow\Model\Processor $processor,
        \FiloBlu\Flow\Model\Map $map,
        Check $check,
        \Magento\Framework\Registry $registry
    )
    {
        parent::__construct($context);
        $this->resultPageFactory = $resultPageFactory;
        $this->_processor = $processor;
        $this->_check = $check;
        $this->_map = $map;
        $this->_registry = $registry;
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface|\Magento\Framework\View\Result\Page|PageFactory
     */
    public function execute()
    {

        //Prendo Il file
        $postDatas = $this->getRequest()->getFiles()['file_csv'];

        if(empty($postDatas)){
            $this->messageManager->addError(__('Si è verificato un errore con il file si prega di riprovare'));
            $this->_redirect('flow/check/index');
        }

        //Setto il file
        $this->_check->setFile($postDatas);

        $chname = $this->_check->getChannelName();

        if(empty($chname)){
            $this->messageManager->addError(__('Attenzione! Il nome del file non corrisponde a nessun canale'));
            return $this->_redirect('flow/check/index');
        }

        //Setto il canale
        $this->_check->setChannel($chname);
        //Inizializzo la mappa
        $this->_check->loadMap();
        //Carico il channel
        $this->_check->loadChannel();

        $channelObj = $this->_check->getChannel();
        $regex = $channelObj['connector']['regex'];

        //Controllo se il numero di colonne del file è coerente con la mappa
        $this->_check->checkColumns();

        //Mostro le colonne della mappatura
        $this->_check->showColumns();

        //Prendo il messagio di output e lo passo alla view
        $output_message = $this->_check->getOutputMessage();

        //echo $output_message;

        $this->_registry->register('check_output_message', $output_message);

        $this->resultPageFactory = $this->resultPageFactory->create();
        $this->resultPageFactory->getConfig()->getTitle()->set((__('CSV Check Result')));

        return $this->resultPageFactory;

    }
}