<?php

namespace FiloBlu\Flow\Controller\Adminhtml\Channel;

use FiloBlu\Flow\Model\Channel;
use Magento\Backend\App\Action;
use Magento\Framework\View\Result\PageFactory;

/**
 * Class Delete
 * @package FiloBlu\Flow\Controller\Adminhtml\Channel
 */
class Delete extends Action
{
    /**
     * @return PageFactory
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('id');
        try {
            $banner = $this->_objectManager->get(Channel::class)->load($id);
            $banner->delete();
            $this->messageManager->addSuccess(
                __('Delete successfully !')
            );
        } catch (\Exception $e) {
            $this->messageManager->addError($e->getMessage());
        }
        $this->_redirect('*/*/');
    }
}
