<?php

namespace FiloBlu\Flow\Console\Command;

use Magento\Framework\Exception\LocalizedException;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class ReceiveCommand
 * @package FiloBlu\Flow\Console\Command
 */
class ReceiveCommand extends BaseCommand
{
    /**
     *
     */
    protected function configure()
    {
        $this->setName('flow:receive')->setDescription('Receive files/data from remote source');
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int
     * @throws LocalizedException
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->ensureAreaCode($output);

        /** @var \FiloBlu\Flow\Cron\Fetch $cronModel */
        $cronModel = $this->fetchFactory->create();
        $cronModel->receive();
        $output->writeln('<info>Receive executed !</info>');

        return 0;
    }
}
