<?php

namespace FiloBlu\Flow\Console\Command;

use Magento\Framework\Exception\LocalizedException;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class ProcessCommand
 * @package FiloBlu\Flow\Console\Command
 */
class ProcessCommand extends BaseCommand
{
    /**
     *
     */
    protected function configure()
    {
        $this->setName('flow:process')->setDescription('Process data channels');
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int
     * @throws LocalizedException
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->ensureAreaCode($output);

        /** @var \FiloBlu\Flow\Cron\Fetch $cronModel */
        $cronModel = $this->fetchFactory->create();
        $cronModel->process();
        $output->writeln('<info>Process executed !</info>');

        return 0;
    }
}
