<?php

namespace FiloBlu\Flow\Console\Command;

use Exception;
use FiloBlu\Flow\Model\Inboundflow;
use FiloBlu\Flow\Model\ResourceModel\Inboundflow\CollectionFactory;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Helper\Table;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class ListCommand
 * @package FiloBlu\Flow\Console\Command
 */
class ListCommand extends Command
{
    /**
     * @var CollectionFactory
     */
    protected $inboundflowFactory;

    /**
     * ListCommand constructor.
     * @param CollectionFactory $inboundflowFactory
     * @param string $name
     */
    public function __construct(
        CollectionFactory $inboundflowFactory,
        $name = null
    ) {
        $this->inboundflowFactory = $inboundflowFactory;
        parent::__construct($name);
    }

    /**
     *
     */
    protected function configure()
    {
        $this->setName('flow:list')
            ->setDescription('List');
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $collection = $this->inboundflowFactory->create();
        $table = new Table($output);
        $rows = [];
        $table->setHeaders(['Id', 'Name', 'Flow', 'Priority', 'Status']);

        /** @var Inboundflow $item */
        foreach ($collection->getItems() as $item) {
            $status = $item->getStatus();
            $rows[] = [
                $item->getId(),
                $item->getName(),
                $item->getFlow(),
                $item->getPriority(),
                $status == Inboundflow::STATUS_ERROR ? "<error>{$status}</error>" : "<info>{$status}</info>"
            ];
        }

        $table->setRows($rows);
        $table->render();

        return 0;
    }
}
