<?php

namespace FiloBlu\Flow\Console\Command;

use Exception;
use Magento\Framework\Exception\LocalizedException;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class CriticalCommand
 * @package FiloBlu\Flow\Console\Command
 */
class CriticalCommand extends BaseCommand
{
    /**
     *
     */
    protected function configure()
    {
        $this->setName('flow:critical')
            ->setDescription('Process critical flows executing fetch receive parse and process in one shot');
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int
     * @throws LocalizedException
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->ensureAreaCode($output);

        $cronModel = $this->fetchFactory->create();
        $cronModel->processCritical();
        $output->writeln('<info>Processed criticals !</info>');

        return 0;
    }
}
