<?php

namespace FiloBlu\Flow\Block;

use Magento\Catalog\Model\ProductFactory;
use Magento\Framework\View\Element\Template;

/**
 * Class Product
 * @package FiloBlu\Flow\Block
 */
class Product extends Template
{
    /**
     * @var ProductFactory
     */
    protected $productFactory;

    /**
     * Product constructor.
     * @param ProductFactory $productFactory
     * @param Template\Context $context
     * @param array $data
     */
    public function __construct(
        ProductFactory $productFactory,
        Template\Context $context,
        array $data = []
    ) {
        $this->productFactory = $productFactory;
        parent::__construct($context, $data);
    }

    /**
     * @param $id
     * @return mixed
     */
    public function getProductLoader($id)
    {
        return $this->productFactory->create()->load($id);
    }
}
