<?php
/**
 * Copyright © 2015 FiloBlu . All rights reserved.
 *
 */
namespace FiloBlu\Flow\Block;

use FiloBlu\Flow\Helper\Data;
use FiloBlu\Flow\Model\Config;
use Magento\Framework\App\CacheInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\App\State;
use Magento\Framework\Escaper;
use Magento\Framework\Event\ManagerInterface;
use Magento\Framework\Filter\FilterManager;
use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\Registry;
use Magento\Framework\Session\SessionManagerInterface;
use Magento\Framework\Session\SidResolverInterface;
use Magento\Framework\Stdlib\DateTime\TimezoneInterface;
use Magento\Framework\Translate\Inline\StateInterface;
use Magento\Framework\UrlFactory;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Asset\Repository;
use Magento\Framework\View\ConfigInterface;
use Magento\Framework\View\DesignInterface;
use Magento\Framework\View\Element\Template\File\Resolver;
use Magento\Framework\View\Element\Template\File\Validator;
use Magento\Framework\View\FileSystem;
use Magento\Framework\View\LayoutInterface;
use Magento\Framework\View\TemplateEnginePool;
use Magento\Store\Model\StoreManagerInterface;
use Psr\Log\LoggerInterface;

/**
 * Abstract product block context
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class Context extends \Magento\Framework\View\Element\Template\Context
{
    /**
     * @var Data
     */
    protected $_devToolHelper;

    /**
     * @var Registry
     */
    protected $registry;

    /**
     * @var Config
     */
    protected $_config;

    /**
     * @var ObjectManagerInterface
     */
    protected $_objectManager;

    /**
     * @var UrlFactory
     */
    protected $_urlFactory;

    /**
     * Context constructor.
     * @param RequestInterface $request
     * @param LayoutInterface $layout
     * @param ManagerInterface $eventManager
     * @param UrlInterface $urlBuilder
     * @param CacheInterface $cache
     * @param DesignInterface $design
     * @param SessionManagerInterface $session
     * @param SidResolverInterface $sidResolver
     * @param ScopeConfigInterface $scopeConfig
     * @param Repository $assetRepo
     * @param ConfigInterface $viewConfig
     * @param \Magento\Framework\App\Cache\StateInterface $cacheState
     * @param LoggerInterface $logger
     * @param Escaper $escaper
     * @param FilterManager $filterManager
     * @param TimezoneInterface $localeDate
     * @param StateInterface $inlineTranslation
     * @param \Magento\Framework\Filesystem $filesystem
     * @param FileSystem $viewFileSystem
     * @param TemplateEnginePool $enginePool
     * @param State $appState
     * @param StoreManagerInterface $storeManager
     * @param \Magento\Framework\View\Page\Config $pageConfig
     * @param Resolver $resolver
     * @param Validator $validator
     * @param Data $devToolHelper
     * @param Registry $registry
     * @param Config $config
     * @param ObjectManagerInterface $objectManager
     * @param UrlFactory $urlFactory
     */
    public function __construct(
        RequestInterface $request,
        LayoutInterface $layout,
        ManagerInterface $eventManager,
        UrlInterface $urlBuilder,
        CacheInterface $cache,
        DesignInterface $design,
        SessionManagerInterface $session,
        SidResolverInterface $sidResolver,
        ScopeConfigInterface $scopeConfig,
        Repository $assetRepo,
        ConfigInterface $viewConfig,
        \Magento\Framework\App\Cache\StateInterface $cacheState,
        LoggerInterface $logger,
        Escaper $escaper,
        FilterManager $filterManager,
        TimezoneInterface $localeDate,
        StateInterface $inlineTranslation,
        \Magento\Framework\Filesystem $filesystem,
        FileSystem $viewFileSystem,
        TemplateEnginePool $enginePool,
        State $appState,
        StoreManagerInterface $storeManager,
        \Magento\Framework\View\Page\Config $pageConfig,
        Resolver $resolver,
        Validator $validator,
        Data $devToolHelper,
        Registry $registry,
        Config $config,
        ObjectManagerInterface $objectManager,
        UrlFactory $urlFactory
    ) {
        $this->_devToolHelper = $devToolHelper;
        $this->registry = $registry;
        $this->_config = $config;
        $this->_objectManager=$objectManager;
        $this->_urlFactory=$urlFactory;
        parent::__construct(
            $request,
            $layout,
            $eventManager,
            $urlBuilder,
            $cache,
            $design,
            $session,
            $sidResolver,
            $scopeConfig,
            $assetRepo,
            $viewConfig,
            $cacheState,
            $logger,
            $escaper,
            $filterManager,
            $localeDate,
            $inlineTranslation,
            $filesystem,
            $viewFileSystem,
            $enginePool,
            $appState,
            $storeManager,
            $pageConfig,
            $resolver,
            $validator
        );
    }

    /**
     * Function for getting developer helper object
     * @return Data
     */
    public function getFlowHelper()
    {
        return $this->_devToolHelper;
    }

    /**
     * Function for getting registry object
     * @return Registry
     */
    public function getRegistry()
    {
        return $this->registry;
    }

    /**
     * Function for getting flow model config object
     * @return Config
     */
    public function getConfig()
    {
        return $this->_config;
    }

    /**
     * Function for getting object manager object
     * @return ObjectManagerInterface
     */
    public function getObjectManager()
    {
        return $this->_objectManager;
    }

    /**
     * Function for getting UrlFactory object
     * @return UrlFactory
     */
    public function getUrlFactory()
    {
        return $this->_urlFactory;
    }
}
