<?php
/**
 * Copyright © 2018 Filoblu S.r.l. All rights reserved.
 */

namespace FiloBlu\Flow\Block\Adminhtml\System\Config;

use Magento\Framework\Option\ArrayInterface;

/**
 * Class FlowFromTypes
 * @package FiloBlu\Flow\Block\Adminhtml\System\Config
 */
class FlowFromTypes implements ArrayInterface
{

    /**
     * @return array
     */
    public function toOptionArray()
    {
        return [
            ['value' => 'From\Product', 'label' => 'From\Product'],
            ['value' => 'From\Eavs', 'label' => 'From\Eavs'],
            ['value' => 'From\Stock', 'label' => 'From\Stock'],
            ['value' => 'From\Multistock', 'label' => 'From\Multistock'],
            ['value' => 'From\Price', 'label' => 'From\Price'],
            ['value' => 'From\Brotherhood', 'label' => 'From\Brotherhood'],
            ['value' => 'Imagesflow', 'label' => 'Imagesflow'],
            ['value' => 'From\Bundle', 'label' => 'From\Bundle'],
            ['value' => 'From\Grouped', 'label' => 'From\Grouped'],
            ['value' => 'From\SharedCatalog', 'label' => 'From\SharedCatalog'],
            ['value' => 'From\SharedCatalogProducts', 'label' => 'From\SharedCatalogProducts'],
            ['value' => 'Document', 'label' => 'Document'],
            ['value' => 'Swatch', 'label' => 'Swatch'],
            ['value' => 'From\SwatchColor', 'label' => 'SwatchColor'],
            ['value' => 'From\StockAdjustment', 'label' => 'StockAdjustment']
        ];
    }

    /**
     * @return array
     */
    public function toArray()
    {
        return [
            'From\Product' => 'From\Product',
            'From\Eavs' => 'From\Eavs',
            'From\Stock' => 'From\Stock',
            'From\Multistock' => 'From\Multistock',
            'From\Price' => 'From\Price',
            'From\Brotherhood' => 'From\Brotherhood',
            'Imagesflow' => 'Imagesflow',
            'From\Bundle' => 'From\Bundle',
            'From\Grouped' => 'From\Grouped',
            'From\SharedCatalog' => 'From\SharedCatalog',
            'From\SharedCatalogProducts' => 'From\SharedCatalogProducts',
            'Document' => 'Document',
            'Swatch' => 'Swatch',
            'From\SwatchColor' => 'SwatchColor',
            'From\StockAdjustment' => 'From\StockAdjustment'
        ];
    }
}

