<?php
declare(strict_types=1);

namespace FiloBlu\Flow\Block\Adminhtml\Option;


use Magento\Catalog\Api\ProductAttributeRepositoryInterface;
use Magento\Framework\Api\SearchCriteriaBuilderFactory;
use Magento\Framework\Data\OptionSourceInterface;

/**
 *
 */
class MediaGalleryOptionSource implements OptionSourceInterface
{
    /**
     * @var ProductAttributeRepositoryInterface
     */
    private $productAttributeRepository;
    /**
     * @var SearchCriteriaBuilderFactory
     */
    private $searchCriteriaBuilderFactory;

    /**
     * @param ProductAttributeRepositoryInterface $productAttributeRepository
     * @param SearchCriteriaBuilderFactory $searchCriteriaBuilderFactory
     */
    public function __construct(ProductAttributeRepositoryInterface $productAttributeRepository,
                                SearchCriteriaBuilderFactory        $searchCriteriaBuilderFactory
    )
    {

        $this->productAttributeRepository = $productAttributeRepository;
        $this->searchCriteriaBuilderFactory = $searchCriteriaBuilderFactory;
    }

    /**
     * Return array of options as value-label pairs
     *
     * @return array Format: array(array('value' => '<value>', 'label' => '<label>'), ...)
     */
    public function toOptionArray()
    {
        $options = [];
        $searchCriteriaBuilder = $this->searchCriteriaBuilderFactory->create();
        $searchCriteriaBuilder->addFilter('frontend_input', 'gallery');

        $result = $this->productAttributeRepository->getList($searchCriteriaBuilder->create());

        foreach ($result->getItems() as $item) {
            $options[] = [
                'value' => $item->getAttributeCode(),
                'label' => $item->getDefaultFrontendLabel()
            ];
        }

        return $options;
    }
}
