<?php

namespace FiloBlu\Flow\Block\Adminhtml\Channel\Edit\Tab;

use FiloBlu\Flow\Model\Channel;
use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Backend\Block\Widget\Tab\TabInterface;
use Magento\Framework\Data\Form;
use Magento\Framework\Exception\LocalizedException;

/**
 * Class Parser
 * @package FiloBlu\Flow\Block\Adminhtml\Channel\Edit\Tab
 */
class Parser extends Generic implements TabInterface
{

    /**
     * Prepare label for tab
     *
     * @return string
     */
    public function getTabLabel()
    {
        return __('Parser');
    }

    /**
     * Prepare title for tab
     *
     * @return string
     */
    public function getTabTitle()
    {
        return __('parser');
    }

    /**
     * {@inheritdoc}
     */
    public function canShowTab()
    {
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function isHidden()
    {
        return false;
    }

    /**
     * Prepare form
     *
     * @return $this
     * @throws LocalizedException
     */
    protected function _prepareForm()
    {
        /** @var Channel $model */
        $model = $this->_coreRegistry->registry('flow_channel');

        /** @var Form $form */
        $form = $this->_formFactory->create();

        $form->setHtmlIdPrefix('page_');

        $fieldset = $form->addFieldset('parser_fieldset', [
            'legend' => __('Parser Map')
        ]);

        $fieldset->addField('type', 'text', [
            'label' => __('Type'),
            'name'  => 'parser[type]',
        ]);

        $fieldset->addField('separator', 'text', [
            'label' => __('Separator'),
            'name'  => 'parser[separator]',
        ]);

        $fieldset->addField('delimiter', 'text', [
            'label' => __('Delimiter'),
            'name'  => 'parser[delimiter]',
        ]);

        $fieldset->addField('lines_to_skip', 'select', [
            'label'   => __('Header in first line'),
            'name'    => 'parser[lines_to_skip]',
            'values'  => [
                '0' => 'No',
                '1' => 'Yes'
            ],
            'default' => '1'
        ]);

        $fieldset->addField('check_mapping_count', 'select', [
                'name'     => 'parser[check_mapping_count]',
                'label'    => __('Check mapping count'),
                'required' => false,
                'values'   => [
                    '0' => 'No',
                    '1' => 'Yes'
                ],
                'default'  => 1,
                'note'     => 'Per Flow di tipo Anagrafica: controllo sul numero di colonne?<br>Se impostato a <b>NO</b>, posso importare un csv con un numero di attributi inferiore a quelli mappati nel json - Header in first line deve essere YES'
            ]);

        $fieldset->addField('prehook', 'text', [
            'label' => __('Prehook'),
            'name'  => 'parser[prehook]',
        ]);

        $fieldset->addField('posthook', 'text', [
            'label' => __('Posthook'),
            'name'  => 'parser[posthook]',
        ]);

        $form->setValues($model->getData('parser'));
        $this->setForm($form);

        return parent::_prepareForm();
    }

    /**
     * Check permission for passed action
     *
     * @param string $resourceId
     * @return bool
     */
    protected function _isAllowedAction($resourceId)
    {
        return $this->_authorization->isAllowed($resourceId);
    }
}
