<?php

namespace FiloBlu\Flow\Block\Adminhtml\Channel;

use Magento\Backend\Block\Widget\Form\Container;

/**
 * CMS block edit form container
 */
class Edit extends Container
{
    /**
     * Get edit form container header text
     *
     * @return string
     */
    public function getHeaderText()
    {
        return __('New Item');
    }

    /**
     *
     */
    protected function _construct()
    {
        $this->_objectId = 'id';
        $this->_blockGroup = 'FiloBlu_Flow';
        $this->_controller = 'adminhtml_channel';

        parent::_construct();

        $this->buttonList->update('save', 'label', __('Save Channel'));
        $this->buttonList->update('delete', 'label', __('Delete Channel'));

        $this->buttonList->add(
            'saveandcontinue',
            [
                'label' => __('Save and Continue Edit'),
                'class' => 'save',
                'data_attribute' => [
                    'mage-init' => ['button' => ['event' => 'saveAndContinueEdit', 'target' => '#edit_form']]
                ]
            ],
            -100
        );

        $this->_formScripts[] = "
            function toggleEditor() {
                if (tinyMCE.getInstanceById('block_content') == null) {
                    tinyMCE.execCommand('mceAddControl', false, 'hello_content');
                } else {
                    tinyMCE.execCommand('mceRemoveControl', false, 'hello_content');
                }
            }
        ";
    }
}
