<?php

namespace FiloBlu\Flow\Api;

use Exception;

/**
 * Interface LogInterface
 * @package FiloBlu\Flow\Api
 */
interface LogInterface
{

    /**
     * @param $id
     * @return mixed
     */
    public function setId($id);

    /**
     * @param $message
     * @return string $message
     */
    public function setMessage($message);

    /**
     * @param $severity
     * @return mixed
     */
    public function setSeverity($severity);

    /**
     * @param $count
     * @return mixed
     */
    public function setErrorRepeatCount($count);

    /**
     * @param $file
     * @return mixed
     */
    public function setMetaFile($file);

    /**
     * @param $time
     * @return mixed
     */
    public function setMetaInsertTime($time);

    /**
     * @param Exception $exception
     * @return mixed
     */
    public function setException(Exception $exception);

    /**
     * @return int
     */
    public function getId();

    /**
     * @return mixed
     */
    public function getStackTrace();

    /**
     * @return string
     */
    public function getMessage();

    /**
     * @return mixed
     */
    public function getSeverity();

    /**
     * @return mixed
     */
    public function getErrorRepeatCount();

    /**
     * @return mixed
     */
    public function getMetaFile();

    /**
     * @return mixed
     */
    public function getMetaInsertTime();

    /**
     * @return string MD5 hash of the stack trace
     */
    public function getStackTraceHash();
}
