<?php

namespace FiloBlu\Flow\Ui\Component\Listing\Column\Log;

use Magento\Ui\Component\Listing\Columns\Column;

/**
 * Class Severity
 * @package FiloBlu\Flow\Ui\Component\Listing\Columns\Log
 */
class Severity extends Column
{
    /**
     * Column name
     */
   // const NAME = 'error_severity';

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        $dataSource = parent::prepareDataSource($dataSource);

        if (empty($dataSource['data']['items'])) {
            return $dataSource;
        }

        foreach ($dataSource['data']['items'] as $k => $item) {
            $dataSource['data']['items'][$k]['error_severity'] = "<div class=\"flow_severity flow_level_{$item['error_severity']}\">{$item['error_severity']}</div>";
        }

        return $dataSource;
    }


}
