<?php

namespace FiloBlu\Flow\Model\Parser\Filters;

/**
 * Class SelectTranslation
 * @package FiloBlu\Flow\Model\Parser\Filters
 */
class SelectTranslation extends AbstractFilter
{
    /**
     * @param $value
     * @param $args
     * @return string
     */
    public function filter($value, $args)
    {
        if ($value === null || trim($value) === '') {
            return '';
        }

        $defaultAttribute = (int)$args['default'];
        $defaultValue = $this->_row[$defaultAttribute];

        if ($defaultValue === null || trim($defaultValue) === '') {
            return '';
        }

        return sprintf('%s;%s', str_replace("'", '', $defaultValue), str_replace("'", '', $value));
    }
}