<?php

namespace FiloBlu\Flow\Model\Filters;

use Exception;
use Magento\Store\Api\StoreRepositoryInterface;

/**
 * Class StoreCodeToStoreIdConverter
 * @package FiloBlu\Flow\Model\Filters
 */
class StoreCodeToStoreIdConverter extends AbstractFilter
{

    protected $storeRepository;

    public function __construct(
        StoreRepositoryInterface $storeRepository
    )
    {
        $this->storeRepository = $storeRepository;
    }

    /**
     * @param $value
     * @param $args
     * @return string
     */
    public function filter($value, $args)
    {
        $store_code = trim($value ?? '');
        try {
            $store = $this->storeRepository->get($store_code);
            return $store->getId();
        } catch (Exception $e) {
        }
        return null;
    }

}
