<?php

namespace FiloBlu\Flow\Model\Filters;

/**
 * Class ForceMinimumNumber
 * @package FiloBlu\Flow\Model\Filters
 * You can force a conversion to a minimum number
 * Example if minimum number is 3 and you pass 2 then will be converted to 3
 * Example if minimum number is 0 and you pass -1 then will be converted to 0
 * Default minimum is 0
 */
class ForceMinimumNumber extends AbstractFilter
{

    /**
     * @param $value
     * @param $args
     * @return mixed
     */
    public function filter($value, $args)
    {
        $min_value = 0;
        if ($args && isset($args['minimum_value']) && count($args)) {
            $min_value = (float)$args['minimum_value'];
        }
        return max((float)$value, $min_value);
    }
}