<?php

namespace FiloBlu\Flow\Helper;

use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory;

/**
 * Class CategoryHelper
 * @package FiloBlu\Flow\Helper
 */
class CategoryHelper
{
    /**
     * @var array
     */
    protected $categoryLookup = [];

    /**
     * @var array
     */
    protected $categoryLookupName = [];

    /**
     * @var array
     */
    protected $categoryLookupNamePath = [];

    /**
     * @var CollectionFactory
     */
    protected $collectionFactory;

    /**
     * CategoryHelper constructor.
     * @param CollectionFactory $collectionFactory
     */
    public function __construct(CollectionFactory $collectionFactory)
    {
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * @return array
     */
    public function getCategoryLookup()
    {
        if (empty($this->categoryLookup) || empty($this->categoryLookupName)) {
            $collection = $this->collectionFactory->create()
                ->setStore(0)
                ->addNameToResult();

            foreach ($collection as $category) {
                $structure = explode('/', $category->getPath());

                // Removing the category ID 1, I don't need that
                if (($key = array_search('1', $structure, false)) !== false) {
                    unset($structure[$key]);
                }

                if (count($structure) === 0) {
                    continue;
                }

                $leafId = end($structure);
                $this->categoryLookup[$leafId] = $structure;
                $category_name = $this->sanitizeCategoryName($category->getName());
                $this->categoryLookupName[$leafId] = $category_name;
            }
        }

        return $this->categoryLookup;
    }

    /**
     * @return array
     */
    public function getCategoryLookupNamePath(){

        if (!empty($this->categoryLookupNamePath)){
            return $this->categoryLookupNamePath;
        }

        $this->getCategoryLookup();
        $collection = $this->collectionFactory->create()
            ->setStore(0)
            ->addNameToResult();

        foreach ($collection as $category) {
            $structure = explode('/', $category->getPath());

            // Removing the category ID 1, I don't need that
            if (($key = array_search('1', $structure, false)) !== false) {
                unset($structure[$key]);
            }

            if (count($structure) === 0) {
                continue;
            }

            $path_names_array = array();
            foreach ($structure as $category_id) {
                $path_names_array[] = $this->categoryLookupName[$category_id];
            }

            $full_path = implode("/",$path_names_array);
            $this->categoryLookupNamePath[$category->getId()] = $full_path;
        }
        return $this->categoryLookupNamePath;
    }

    /**
     * @param null $string_path
     * @return false|int
     */
    public function getCategoryIdByStringPath($string_path = null){
        if (!$string_path || is_numeric($string_path)){
            return false;
        }
        $exploded = explode("/",$string_path);
        foreach ($exploded as &$v) {
            $v = $this->sanitizeCategoryName($v);
        }
        $sanitized_string_path = implode("/",$exploded);
        $this->getCategoryLookupNamePath();
        foreach ($this->categoryLookupNamePath as $cat_id => $path) {
            if ($path == $sanitized_string_path){
                return $cat_id;
            }
        }
        return false;
    }

    /**
     * @param $string
     * @return string
     */
    public function sanitizeCategoryName($string){
        $lowertrimmed = strtolower(trim($string));
        $cleaned = preg_replace('/[^a-z\d ]+/i', '', $lowertrimmed);
        return $cleaned;
    }
}
