<?php
/**
 * Copyright © 2015 FiloBlu . All rights reserved.
 */

namespace FiloBlu\Flow\Block;

use FiloBlu\Flow\Helper\Data;
use FiloBlu\Flow\Model\Config;
use Magento\Framework\Url;
use Magento\Framework\View\Element\Template;

/**
 * Class BaseBlock
 * @package FiloBlu\Flow\Block
 */
class BaseBlock extends Template
{
    /**
     * @var Data
     */
    protected $_devToolHelper;

    /**
     * @var Url
     */
    protected $_urlApp;

    /**
     * @var Config
     */
    protected $_config;

    /**
     * BaseBlock constructor.
     * @param Context $context
     */
    public function __construct(Context $context)
    {
        $this->_devToolHelper = $context->getFlowHelper();
        $this->_config = $context->getConfig();
        $this->_urlApp = $context->getUrlFactory()->create();
        parent::__construct($context);

    }

    /**
     * Function for getting event details
     * @return array
     */
    public function getEventDetails()
    {
        return $this->_devToolHelper->getEventDetails();
    }

    /**
     * Function for getting current url
     * @return string
     */
    public function getCurrentUrl()
    {
        return $this->_urlApp->getCurrentUrl();
    }

    /**
     * Function for getting controller url for given router path
     * @param string $routePath
     * @return string
     */
    public function getControllerUrl($routePath)
    {
        return $this->_urlApp->getUrl($routePath);
    }

    /**
     * Function canShowFlow
     * @return bool
     */
    public function canShowFlow()
    {
        $isEnabled = $this->getConfigValue('flow/module/is_enabled');

        if (!$isEnabled) {
            return false;
        }

        $allowedIps = $this->getConfigValue('flow/module/allowed_ip');

        if (is_null($allowedIps)) {
            return true;
        }

        $remoteIp = $_SERVER['REMOTE_ADDR'];
        if (strpos($allowedIps, $remoteIp) !== false) {
            return true;
        }

        return false;
    }

    /**
     * Function for getting current url
     * @param string $path
     * @return string
     */
    public function getConfigValue($path)
    {
        return $this->_config->getCurrentStoreConfigValue($path);
    }

}
