<?php


namespace FiloBlu\Flow\Setup;


use Magento\Catalog\Model\Product;
use Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface as Attribute;
use Magento\Eav\Setup\EavSetup;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\DB\Adapter\Pdo\Mysql;
use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\UpgradeDataInterface;

class UpgradeData implements UpgradeDataInterface
{

    /**
     * EAV setup factory
     *
     * @var EavSetupFactory
     */
    private $eavSetupFactory;

    /**
     * Init
     *
     * @param EavSetupFactory $eavSetupFactory
     */
    public function __construct(EavSetupFactory $eavSetupFactory)
    {
        $this->eavSetupFactory = $eavSetupFactory;
    }

    /**
     * @inheritDoc
     */
    public function upgrade(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        if (version_compare($context->getVersion(), '1.0.16') < 0) {
            $this->addNewColumn($setup, $context);
        }

        if (version_compare($context->getVersion(), '1.0.261') < 0) {
            $this->addDocumentColumn($setup, $context);
        }
    }

    /**
     * Installs data
     *
     * @param ModuleDataSetupInterface $setup
     * @param ModuleContextInterface $context
     * @return void
     * @throws \Zend_Db_Exception
     */
    public function addNewColumn(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;
        $installer->startSetup();

        /** @var MySql $connection */
        $connection = $setup->getConnection();

        $connection->addColumn(
            $installer->getTable('flow_from_price'),
            'special_price',
            [
                'type' => Table::TYPE_DECIMAL,
                'length' => '12,4',
                'nullable' => true,
                'comment' => 'Special Price',
                'after'    => 'prezzo'
            ]
        );
        $installer->endSetup();
    }

    /**
     * @param ModuleDataSetupInterface $setup
     * @param ModuleContextInterface $context
     * @return void
     */
    public function addDocumentColumn(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;
        $installer->startSetup();

        /** @var MySql $connection */
        $connection = $setup->getConnection();

        $connection->addColumn(
            $installer->getTable('flow_document'),
            'entity_identifier_value',
            [
                'type' => Table::TYPE_TEXT,
                'length' => '50',
                'nullable' => true,
                'comment' => 'Entity Identifier Value',
                'after'    => 'name'
            ]
        );

        $connection->addColumn(
            $installer->getTable('flow_document'),
            'entity_store_id',
            [
                'type' => Table::TYPE_TEXT,
                'length' => '50',
                'nullable' => true,
                'comment' => 'Entity Store Id',
                'after'    => 'name'
            ]
        );
        $installer->endSetup();
    }

}
