<?php

namespace FiloBlu\Flow\Model;

use Exception;
use FiloBlu\Flow\Api\LogInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * Class Log
 * @package FiloBlu\Flow\Model
 */
class Log extends AbstractModel implements LogInterface
{
    /**
     * @return void
     */
    public function _construct()
    {
        $this->_init(ResourceModel\Log::class);
    }

    /**
     * @param Exception $exception
     * @return mixed|void
     */
    public function setException(Exception $exception)
    {
        //  $stackTrace = $exception->getTrace();

        $this->setData('stack_trace', $exception->getTraceAsString());
    }

    /**
     * @param $message
     * @return string
     */
    public function setMessage($message)
    {
        $this->setData('message', $message);
    }

    /**
     * @param $severity
     * @return mixed
     */
    public function setSeverity($severity)
    {
        $this->setData('error_severity', $severity);
    }

    /**
     * @param $count
     * @return mixed
     */
    public function setErrorRepeatCount($count)
    {
        $this->setData('error_repeat_count', $count);
    }

    /**
     * @param $file
     * @return mixed
     */
    public function setMetaFile($file)
    {
        $this->setData('meta_file', $file);
    }

    /**
     * @param $time
     * @return mixed
     */
    public function setMetaInsertTime($time)
    {
        $this->setData('meta_insert_time', $time);
    }

    /**
     * @return mixed
     */
    public function getStackTrace()
    {
        return $this->getData('stack_trace');
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->getData('message');
    }

    /**
     * @return mixed
     */
    public function getSeverity()
    {
        return $this->getData('error_severity');
    }

    /**
     * @return mixed
     */
    public function getErrorRepeatCount()
    {
        return $this->getData('error_repeat_count');
    }

    /**
     * @return mixed
     */
    public function getMetaFile()
    {
        return $this->getData('meta_file');
    }

    /**
     * @return mixed
     */
    public function getMetaInsertTime()
    {
        return $this->getData('meta_insert_time');
    }

    /**
     * @return string MD5 hash of the stack trace
     */
    public function getStackTraceHash()
    {
        return md5($this->getData('stack_trace'));
    }
}
