<?php
declare(strict_types=1);

namespace FiloBlu\Flow\Model\Actions\From;

use Exception;

/**
 * Class Addtocategoryparent
 * @package FiloBlu\Flow\Model\Actions\From
 */
class Addtocategoryparent extends Addtocategory
{

    /**
     * @param $product
     * @param $categoriesString
     * @param $storeId
     * @return void
     * @throws Exception
     */
    public function process($product, $categoriesString, $storeId)
    {
        $parents = $this->productHelper->getParentsByChild($product);
        if (empty($parents) && $product->isComposite()) {
            $parents[] = $product;
        }

        foreach ($parents as $parent) {
            parent::process($parent, $categoriesString, $storeId);
        }
    }
}
