<?php

namespace FiloBlu\Flow\Controller\Adminhtml\Inboundflow;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Page;
use Magento\Framework\View\Result\PageFactory;

/**
 * Class Index
 * @package FiloBlu\Flow\Controller\Adminhtml\Inboundflow
 */
class Index extends Action
{
    /**
     * @var PageFactory
     */
    protected $resultPageFactory;

    /**
     * @var Page
     */
    protected $resultPage;

    /**
     * @param Context $context
     * @param PageFactory $resultPageFactory
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory
    ) {
        parent::__construct($context);
        $this->resultPageFactory = $resultPageFactory;
    }

    public function execute()
    {
        $this->resultPage = $this->resultPageFactory->create();
        $this->resultPage->setActiveMenu('FiloBlu_Inboundflow::inboundflow');
        $this->resultPage->getConfig()->getTitle()->set(__('Inboundflow'));
        return $this->resultPage;
    }
}
