<?php

namespace FiloBlu\Flow\Block\Adminhtml\Inboundflow\Edit\Tab;

use FiloBlu\Flow\Model\Inboundflow;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Backend\Block\Widget\Tab\TabInterface;
use Magento\Cms\Model\Page;
use Magento\Framework\Data\Form;
use Magento\Framework\Data\FormFactory;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Registry;

/**
 * Class General
 * @package FiloBlu\Flow\Block\Adminhtml\Inboundflow\Edit\Tab
 */
class General extends Generic implements TabInterface
{

    /**
     * @param Context $context
     * @param Registry $registry
     * @param FormFactory $formFactory
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        FormFactory $formFactory,
        array $data = []
    ) {
        parent::__construct($context, $registry, $formFactory, $data);
    }

    /**
     * Prepare label for tab
     *
     * @return string
     */
    public function getTabLabel()
    {
        return __('General');
    }

    /**
     * Prepare title for tab
     *
     * @return string
     */
    public function getTabTitle()
    {
        return __('General');
    }

    /**
     * {@inheritdoc}
     */
    public function canShowTab()
    {
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function isHidden()
    {
        return false;
    }

    /**
     * @return Generic
     * @throws LocalizedException
     */
    protected function _prepareForm()
    {
        /* @var $model Page */
        $model = $this->_coreRegistry->registry('flow_inboundflow');
        $isElementDisabled = false;
        /** @var Form $form */
        $form = $this->_formFactory->create();

        $form->setHtmlIdPrefix('page_');

        $fieldset = $form->addFieldset('base_fieldset', ['legend' => __('General')]);

        if ($model->getId()) {
            $fieldset->addField('id', 'hidden', ['name' => 'id']);
        }

        $fieldset->addField(
            'name',
            'text',
            [
                'name' => 'name',
                'label' => __('name'),
                'title' => __('name'),
            ]
        );
        $fieldset->addField(
            'priority',
            'select',
            [
                'name' => 'priority',
                'label' => __('priority'),
                'title' => __('priority'),
                'options' => Inboundflow::getPriorityList()
            ]
        );
        $fieldset->addField(
            'status',
            'select',
            [
                'name' => 'status',
                'label' => __('status'),
                'title' => __('status'),
                'options' => Inboundflow::getStatusList(['' => 'Nessuno Stato']),
                'required' => true,
            ]
        );
        $fieldset->addField(
            'log',
            'textarea',
            [
                'name' => 'log',
                'label' => __('Log'),
                'title' => __('Log'),
            ]
        );
        $fieldset->addField(
            'comment',
            'textarea',
            [
                'name' => 'comment',
                'label' => __('comment'),
                'title' => __('comment'),
            ]
        );

        if (!$model->getId()) {
            $model->setData('status', $isElementDisabled ? '2' : '1');
        }

        $form->setValues($model->getData());
        $this->setForm($form);

        return parent::_prepareForm();
    }

    /**
     * Check permission for passed action
     *
     * @param string $resourceId
     * @return bool
     */
    protected function _isAllowedAction($resourceId)
    {
        return $this->_authorization->isAllowed($resourceId);
    }
}
