<?php
/**
 * Copyright © 2013-2017 Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace FiloBlu\Flow\Block\Adminhtml\Category;

use Magento\Backend\Block\Widget\Context;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

/**
 * Class SaveButton
 */
class ExportButton implements ButtonProviderInterface
{
    /**
     * @var Context
     */
    protected $context;

    /**
     * ExportButton constructor.
     * @param Context $context
     */
    public function __construct(
        Context $context
    ) {
        $this->context = $context;
    }

    /**
     * Save button
     *
     * @return array
     */
    public function getButtonData()
    {
        return [
            'label' => __('Export'),
            'class' => 'delete',
            'on_click' => sprintf("location.href = '%s';", $this->getUrl()),
            'sort_order' => 30,
        ];
    }

    /**
     * @param string $route
     * @param array $params
     * @return string
     */
    public function getUrl($route = '', $params = [])
    {
        return $this->context->getUrlBuilder()->getUrl('flow/category/export', $params);
    }
}
