<?php

namespace FiloBlu\Flow\Setup;

use Magento\Framework\DB\Adapter\Pdo\MySql;
use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

/**
 * Class InstallData
 * @package FiloBlu\Flow\Setup
 */
class InstallData implements InstallDataInterface
{
    /**
     * Installs data
     *
     * @param ModuleDataSetupInterface $setup
     * @param ModuleContextInterface $context
     * @return void
     * @throws \Zend_Db_Exception
     */
    public function install(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;
        $installer->startSetup();

        /** @var MySql $connection */
        $connection = $setup->getConnection();
        $channelTableName = $setup->getTable('flow_channels');
        $data = [];

        $data[] = [
            'name' => 'ite_masterfile',
            'data' => '{"config":{"flow":"From\\Product","copy_to_ite":"0","ite_channel_name":"ite_masterfile","bus":"1","priority":"high","type":"file"},"connector":{"type":"ftp","host":"","username":"","password":"","passive":"1","ftp_dir":"\/IN","local_dir":"common\/bouncer","regex":"#^ite_#is"},"parser":{"type":"csv","separator":";","delimiter":"\"","lines_to_skip":"1","check_mapping_count":"0","prehook":"","posthook":""},"map":{"codice_articolo":{"from":"codice_articolo","to":"codice_articolo","type":"text","validators":[],"filters":[],"stores":[],"locale":[],"actions":[]},"codice_articolo_del_fornitore":{"from":"codice_articolo_del_fornitore","to":"codice_articolo_del_fornitore","type":"text","validators":[],"filters":[],"stores":[],"locale":[],"actions":[]},"nome_articolo":{"from":"nome_articolo","to":"nome_articolo","type":"text","validators":[],"filters":[],"stores":[],"locale":"it","actions":[]},"codice_configurabile":{"from":"codice_configurabile","to":"codice_configurabile","type":"text","validators":[],"filters":[],"stores":[],"locale":[],"actions":[]},"configurable_attributes":{"from":"configurable_attributes","to":"configurable_attributes","type":"text","validators":[],"filters":[],"stores":[],"locale":[],"actions":[]},"configurable_values":{"from":"configurable_values","to":"configurable_values","type":"text","validators":[],"filters":[],"stores":[],"locale":[],"actions":[]},"taxvat_code":{"from":"taxvat_code","to":"taxvat_code","type":"text","validators":[],"filters":[],"stores":[],"locale":[],"actions":[]},"visibility":{"from":"visibility","to":"visibility","type":"text","validators":[],"filters":[],"stores":[],"locale":[],"actions":[]}}}',
            'type' => 'in'
        ];
        $data[] = [
            'name' => 'anagrafica_masterfile',
            'data' => '{"config":{"flow":"From\\Eavs","copy_to_ite":"0","ite_channel_name":"anagrafica_masterfile","bus":"1","priority":"normal","type":"file"},"connector":{"type":"ftp","host":"","username":"","password":"","passive":"1","ftp_dir":"\/IN","local_dir":"common\/bouncer","regex":"#^eavs_#is"},"parser":{"type":"csv","separator":";","delimiter":"\"","lines_to_skip":"1","check_mapping_count":"0","prehook":"","posthook":""},"map":{"sku":{"from":"e","to":"e","type":"text","validators":[],"filters":[],"stores":[],"locale":[]},"a":{"from":"a","to":"a","type":"text","validators":[],"filters":[],"stores":[],"locale":[]},"v":{"from":"v","to":"v","type":"text","validators":[],"filters":[],"stores":[],"locale":[]},"s":{"from":"s","to":"s","type":"text","validators":[],"filters":[],"stores":[],"locale":[]},"l":{"from":"l","to":"l","type":"text","validators":[],"filters":[],"stores":[],"locale":[]}}}',
            'type' => 'in'
        ];
        $data[] = [
            'name' => 'stock',
            'data' => '{"config":{"flow":"From\\Stock","copy_to_ite":"0","ite_channel_name":"","bus":"2","priority":"critical","type":"file"},"connector":{"type":"ftp","host":"","username":"","password":"","passive":"1","ftp_dir":"\/IN","local_dir":"common\/bouncer","regex":"#^nsinventory_#is"},"parser":{"type":"csv","separator":",","delimiter":"\"","lines_to_skip":"1","check_mapping_count":"1","prehook":"","posthook":""},"map":{"sku":{"from":"sku","to":"sku","type":"text","validators":[],"filters":[],"stores":"","locale":"","actions":[]},"qty":{"from":"qty","to":"fisico_disponibile","type":"text","validators":[],"filters":[],"stores":"","locale":"","actions":[]}},"use_map":"1"}',
            'type' => 'in'
        ];
        $data[] = [
            'name' => 'price',
            'data' => '{"config":{"flow":"From\\Price","copy_to_ite":"0","ite_channel_name":"","bus":"3","priority":"low","type":"file"},"connector":{"type":"ftp","host":"","username":"","password":"","passive":"1","ftp_dir":"\/IN","local_dir":"common\/bouncer","regex":"#^prices_#is"},"parser":{"type":"csv","separator":";","delimiter":"\"","lines_to_skip":"1","check_mapping_count":"1","prehook":"","posthook":""},"map":{"sku":{"from":"sku","to":"sku","type":"text","validators":[],"filters":[],"expand_configurables":0},"paese":{"from":"Catalog","to":"paese","type":"","currency":"","website":[],"validators":[],"filters":[{"class":"Trim","args":{"attributes":[]}}],"joins":[{}],"direct_insert":1},"valuta":{"from":"Currency","to":"valuta","type":"","currency":"","website":[],"validators":[],"filters":[{"class":"Trim","args":{"attributes":[]}}]},"prezzo":{"from":"price","to":"prezzo","type":"price","currency":"","website":[],"validators":[],"filters":[{"class":"Trim","args":{"attributes":[]}}]}},"use_map":"1"}',
            'type' => 'in'
        ];
        $data[] = [
            'name' => 'images',
            'data' => '{"config":{"flow":"Imagesflow","copy_to_ite":"0","ite_channel_name":"","bus":"4","priority":"high","type":"image"},"connector":{"type":"ftp","host":"","username":"","password":"","passive":"1","ftp_dir":"\/IMAGES","local_dir":"common\/bouncer\/images","regex":"##"},"parser":{"type":"csv","separator":";","delimiter":"\"","lines_to_skip":"0","check_mapping_count":"0","prehook":"","posthook":""},"map":{"fields":[{"name":"sku","type":"sku"},{"name":"position","type":"position"}],"types":{"01":{"type":["image","thumbnail"]},"02":{"type":["small_image"]}}},"use_map":"1"}',
            'type' => 'in'
        ];

        $data[] = [
            'name' => 'video_thumbnail',
            'data' => '{"config":{"flow":"Imagesflow","custom_module_model":"","concurrency":"1","allow_retry":"0","bus":"4","priority":"high","type":"image","image_media_gallery":"media_gallery","sizeguide_html":""},"connector":{"type":"ftp","host":"","username":"","password":"","passive":"1","ftp_dir":"\\/VIDEO_THUMBNAIL","local_dir":"common\\/bouncer\\/images","regex":"##"},"parser":{"type":"csv","separator":";","delimiter":"\\"","lines_to_skip":"1","check_mapping_count":"0","prehook":"","posthook":""},"map":{"fields":[{"name":"sku","type":"sku"}]},"use_map":"1"}',
            'type' => 'in'
        ];

        $connection->insertMultiple($channelTableName, $data);
        $installer->endSetup();
    }
}
