<?php

declare(strict_types=1);

namespace FiloBlu\Flow\Model;

use Magento\CatalogUrlRewrite\Model\ProductUrlPathGenerator as MagentoProductUrlPathGenerator;
use Magento\Catalog\Model\Product;

/**
 * Model product url path generator
 */
class ProductUrlPathGenerator extends MagentoProductUrlPathGenerator
{
    /**
     * Prepare url key for product
     *
     * @param Product $product
     * @return string
     */
    protected function prepareProductUrlKey(Product $product)
    {
        $urlKey = (string)$product->getUrlKey();
        $urlKey = trim(strtolower($urlKey));

        if ($urlKey) {
            return $product->formatUrlKey($urlKey);
        }

        if ($product->getId()) {
            return $product->formatUrlKey("{$product->getName()}_{$product->getId()}");
        }

        return $product->formatUrlKey("{$product->getName()}_{$product->getSku()}");
    }
}
