<?php
declare(strict_types=1);

namespace FiloBlu\Flow\Model\From;

use FiloBlu\Flow\Helper\SharedCatalogHelper;
use Magento\Catalog\Api\Data\TierPriceInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;
use Magento\Store\Model\StoreManagerInterface;

/**
 * @Class SharedCatalogPrices
 * @package FiloBlu\Flow\Model\From
 */
class SharedCatalogPrices extends AbstractFrom
{

    /** @var string  */
    const SHARED_CATALOG_PRICES_TABLE = 'flow_from_sharedcatalog_prices';

    /**
     * @var SharedCatalogHelper
     */
    private $sharedCatalogHelper;
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;
    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    /**
     * @param SharedCatalogHelper $sharedCatalogHelper
     * @param ResourceConnection $resourceConnection
     * @param Context $context
     * @param Registry $registry
     * @param StoreManagerInterface $storeManager
     * @param AbstractResource|null $resource
     * @param AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        SharedCatalogHelper   $sharedCatalogHelper,
        ResourceConnection    $resourceConnection,
        Context               $context,
        Registry              $registry,
        StoreManagerInterface $storeManager,
        AbstractResource      $resource = null,
        AbstractDb            $resourceCollection = null,
        array                 $data = []
    )
    {
        $this->storeManager = $storeManager;
        $this->sharedCatalogHelper = $sharedCatalogHelper;
        $this->resourceConnection = $resourceConnection;
        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
    }

    /**
     * @param $file
     * @return void
     * @throws LocalizedException
     */
    public function processFileRows($file)
    {
        $rows = $this->sharedCatalogHelper->getSharedCatalogPricesRows((int)$file->getId());
        $sharedCatalogArray = [];
        foreach ($rows as $row) {
            $sharedCatalogArray[(string)$row['sharedcatalog']][$row['sku']] = [
                'price' => (float)$row['price'],
                'price_type' => $row['price_type'],
                'quantity' => (float)$row['quantity']
            ];
        }

        foreach ($sharedCatalogArray as $sharedCatalogName => $products) {
            $this->sharedCatalogHelper->processSharedCatalog($sharedCatalogName, $products);
        }
    }

    public function sendErrorNotifications($file)
    {
        // TODO: Implement sendErrorNotifications() method.
    }

    public function process()
    {
        // TODO: Implement process() method.
        $a = 2;
    }

    /**
     * @return void
     */
    public function _construct()
    {
        $this->_init(\FiloBlu\Flow\Model\ResourceModel\From\SharedCatalogPrices::class);
    }
}
