<?php

namespace FiloBlu\Flow\Model\Filters;

use RuntimeException;

/**
 * Class AbstractFilter
 * @package FiloBlu\Flow\Model\Filters
 */
abstract class AbstractFilter
{
    /**
     * @var
     */
    protected $_row;
    /**
     * @var
     */
    private $columnsMap;

    /**
     * @return mixed
     */
    public function getRow()
    {
        return $this->_row;
    }

    /**
     * @param $row
     */
    public function setRow($row)
    {
        $this->_row = $row;
    }

    /**
     * @param $value
     * @param $args
     * @return mixed
     */
    abstract public function filter($value, $args);

    /**
     * @param $map
     */
    public function setColumnsMap($map)
    {
        $this->columnsMap = $map;
    }

    /**
     * @param $name
     * @return int
     * @throws RuntimeException
     */
    public function getColumnIndexByName($name): int
    {
        if (!isset($this->columnsMap[$name])) {
            throw new RuntimeException("Column '$name' not found");
        }

        return (int)$this->columnsMap[$name];
    }
}
