<?php

namespace FiloBlu\Flow\Helper;

use Magento\Framework\App\Config\ScopeConfigInterface;

/**
 * Class Website
 * @package FiloBlu\Flow\Helper
 */
class Website
{
    /**
     * @var string
     */
    const WEBSITES_MAPPING = 'filoblu_flow/flow_ite/masterfile_website_mapping';

    /**
     * @var array
     */
    protected $websites = [];

    /**
     * @var ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var System
     */
    protected $systemHelper;

    /**
     * Website constructor.
     * @param ScopeConfigInterface $scopeConfig
     * @param System $systemHelper
     */
    public function __construct(ScopeConfigInterface $scopeConfig, System $systemHelper)
    {
        $this->scopeConfig = $scopeConfig;
        $this->systemHelper = $systemHelper;
    }

    /**
     * @param $channel
     * @return mixed
     */
    public function getIds($channel)
    {
        if (isset($this->websites[$channel])) {
            return $this->websites[$channel];
        }

        $configMappings = $this->systemHelper->getSerializedValue($this->scopeConfig->getValue(self::WEBSITES_MAPPING));

        foreach ($configMappings as $configMapping) {
            $this->websites[$configMapping['channel']] = $configMapping['website_id'];
        }

        return $this->websites[$channel];
    }
}
