<?php
/**
 * Copyright © 2015 FiloBlu. All rights reserved.
 */

namespace FiloBlu\Flow\Helper;

use Exception;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Filesystem;
use Monolog\Handler\StreamHandler;
use Monolog\Logger;

/**
 * Class LoggerProvider
 * @package FiloBlu\Flow\Helper
 */
class LoggerProvider
{

    /**
     * @var Monolog\Logger
     */
    protected $_logger;

    /**
     * LoggerProvider constructor.
     * @param Filesystem $filesystem
     * @param string $filename
     * @throws Exception
     */
    public function __construct(
        Filesystem $filesystem,
        $filename = 'mod2-flow'
    )
    {
        $channelName = 'flow-channel';
        $this->_logger = new Logger($channelName);
        $varDirectory = $filesystem
            ->getDirectoryRead(DirectoryList::VAR_DIR)
            ->getAbsolutePath();

        $this->_logger->pushHandler(new StreamHandler(
            $varDirectory . 'log' . DIRECTORY_SEPARATOR . basename($filename) . '.log'
        ));
    }

    /**
     * @return Monolog\Logger|Logger
     */
    public function getLogger()
    {
        return $this->_logger;
    }

}