<?php

namespace FiloBlu\Flow\Console\Command;

use Exception;
use FiloBlu\Flow\Cron\FetchFactory;
use Magento\Framework\App\Area;
use Magento\Framework\App\State;
use Magento\Framework\Exception\LocalizedException;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class ParseCommand
 * @package FiloBlu\Flow\Console\Command
 */
class BaseCommand extends Command
{
    /**
     * @var State
     */
    protected $state;

    /**
     * @var FetchFactory
     */
    protected $fetchFactory;

    /**
     * BaseCommand constructor.
     * @param State $state
     * @param FetchFactory $fetchFactory
     * @param string $name
     */
    public function __construct(
        State $state,
        FetchFactory $fetchFactory,
        $name = null
    ) {
        $this->state = $state;
        $this->fetchFactory = $fetchFactory;
        parent::__construct($name);
    }

    /**
     * @param OutputInterface $output
     * @throws LocalizedException
     */
    protected function ensureAreaCode(OutputInterface $output)
    {
        try {
            $this->state->setAreaCode(Area::AREA_ADMINHTML);
        } catch (Exception $e) {
            $currentAreaCode = $this->state->getAreaCode();
            $output->writeln("Area code was already set to {$currentAreaCode}");
        }
    }
}
