<?php
/**
 * Copyright © 2015 FiloBlu. All rights reserved.
 */

namespace FiloBlu\Flow\Setup;

use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Zend_Db_Exception;

/**
 * @codeCoverageIgnore
 */
class InstallSchema implements InstallSchemaInterface
{
    /**
     * {@inheritdoc}
     */
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;

        $installer->startSetup();

        /**
         * Create table 'flow_inboundflow' if not exists
         */
        if (!$installer->tableExists('flow_inboundflow')) {
            $table = $installer->getConnection()->newTable(
                $installer->getTable('flow_inboundflow')
            )
                ->addColumn(
                    'id',
                    Table::TYPE_INTEGER,
                    null,
                    ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                    'flow_inboundflow'
                )
                ->addColumn(
                    'name',
                    Table::TYPE_TEXT,
                    '64k',
                    [],
                    'name'
                )
                ->addColumn(
                    'flow',
                    Table::TYPE_TEXT,
                    '64k',
                    [],
                    'flow'
                )
                ->addColumn(
                    'type',
                    Table::TYPE_TEXT,
                    '64k',
                    [],
                    'type'
                )
                ->addColumn(
                    'channel',
                    Table::TYPE_TEXT,
                    '64k',
                    [],
                    'channel'
                )
                ->addColumn(
                    'priority',
                    Table::TYPE_TEXT,
                    '64k',
                    [],
                    'priority'
                )
                ->addColumn(
                    'status',
                    Table::TYPE_TEXT,
                    '64k',
                    [],
                    'status'
                )
                ->addColumn(
                    'retry',
                    Table::TYPE_TEXT,
                    '64k',
                    [],
                    'retry'
                )
                ->addColumn(
                    'receiving_time',
                    Table::TYPE_TIMESTAMP,
                    null,
                    ['nullable' => false],
                    'receiving_time'
                )
                ->addColumn(
                    'log',
                    Table::TYPE_TEXT,
                    '64k',
                    [],
                    'log'
                )
                ->addColumn(
                    'comment',
                    Table::TYPE_TEXT,
                    '64k',
                    [],
                    'comment'
                )
                /* ->addIndex(
                    $installer->getIdxName(
                        'FILENAME',
                        [
                            'name'
                        ],
                        AdapterInterface::INDEX_TYPE_UNIQUE
                    ),
                    [
                        'name'
                    ] ,
                    [
                        'type' => AdapterInterface::INDEX_TYPE_UNIQUE
                    ]
                ) */
                ->setComment(
                    'FiloBlu Flow flow_inboundflow'
                );

            $installer->getConnection()->createTable($table);
        }

        /**
         * Create table 'flow_channels' if not exists
         */

        if (!$installer->tableExists('flow_channels')) {
            $table_channels = $installer->getConnection()->newTable(
                $installer->getTable('flow_channels')
            )
                ->addColumn(
                    'id',
                    Table::TYPE_INTEGER,
                    null,
                    ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                    'flow_channels'
                )
                ->addColumn(
                    'name',
                    Table::TYPE_TEXT,
                    '40',
                    [],
                    'name'
                )
                ->addColumn(
                    'data',
                    Table::TYPE_TEXT,
                    '64k',
                    [],
                    'data'
                )
                ->addColumn(
                    'type',
                    Table::TYPE_TEXT,
                    '20',
                    [],
                    'type'
                )
                ->setComment(
                    'FiloBlu Flow flow_channels'
                );

            $installer->getConnection()->createTable($table_channels);
        }

        /**
         * Create table 'flow_from_ite' if not exists
         */
        if (!$installer->tableExists('flow_from_ite')) {
            $table_ite = $installer->getConnection()->newTable(
                $installer->getTable('flow_from_ite')
            )
                ->addColumn(
                    'codice_articolo',
                    Table::TYPE_TEXT,
                    '100',
                    [],
                    'sku'
                )
                ->addColumn(
                    'codice_articolo_del_fornitore',
                    Table::TYPE_TEXT,
                    '100',
                    [],
                    'barcode'
                )
                ->addColumn(
                    'nome_articolo',
                    Table::TYPE_TEXT,
                    '100',
                    [],
                    'nome_articolo'
                )
                ->addColumn(
                    'codice_configurabile',
                    Table::TYPE_TEXT,
                    '30',
                    [],
                    'codice_configurabile'
                )
                ->addColumn(
                    'fascia_iva_articoli',
                    Table::TYPE_TEXT,
                    '10',
                    [],
                    'fascia_iva_articoli'
                )
                ->addColumn(
                    'meta_id',
                    Table::TYPE_INTEGER,
                    null,
                    ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                    'flow_channels'
                )
                ->addColumn(
                    'meta_ref_id',
                    Table::TYPE_INTEGER,
                    '11',
                    [],
                    'meta_ref_id'
                )
                ->addColumn(
                    'meta_file',
                    Table::TYPE_INTEGER,
                    null,
                    ['unsigned' => true, 'nullable' => false],
                    'meta_file'
                )
                ->addColumn(
                    'meta_processed',
                    Table::TYPE_INTEGER,
                    '1',
                    [],
                    'meta_processed'
                )
                ->addColumn(
                    'meta_insert_time',
                    Table::TYPE_DATETIME,
                    '10',
                    ['unsigned' => true, 'nullable' => false],
                    'meta_insert_time'
                )
                ->addColumn(
                    'meta_process_time',
                    Table::TYPE_DATETIME,
                    '10',
                    [],
                    'meta_process_time'
                )
                ->addIndex(
                    $installer->getIdxName('flow_from_ite_meta_file', ['meta_file']),
                    ['meta_file']
                )
                ->addForeignKey(
                    $installer->getFkName(
                        'flow_from_ite',
                        'meta_file',
                        'flow_inboundflow',
                        'id'
                    ),
                    'meta_file',
                    $installer->getTable('flow_inboundflow'),
                    'id',
                    Table::ACTION_CASCADE
                )
                /*{{CedAddTableColumn}}}*/
                ->setComment(
                    'FiloBlu Flow flow_channels'
                );

            $installer->getConnection()->createTable($table_ite);
            /*{{CedAddTable}}*/
        }

        /**
         * Create table 'flow_from_eavs' if not exists
         */
        if (!$installer->tableExists('flow_from_eavs')) {
            $table_eavs = $installer->getConnection()->newTable(
                $installer->getTable('flow_from_eavs')
            )
                ->addColumn(
                    'e',
                    Table::TYPE_TEXT,
                    '255',
                    [],
                    'e'
                )
                ->addColumn(
                    'a',
                    Table::TYPE_TEXT,
                    '255',
                    [],
                    'a'
                )
                ->addColumn(
                    'v',
                    Table::TYPE_TEXT,
                    '65535',
                    [],
                    'v'
                )
                ->addColumn(
                    's',
                    Table::TYPE_TEXT,
                    '255',
                    [],
                    's'
                )
                ->addColumn(
                    'meta_id',
                    Table::TYPE_INTEGER,
                    null,
                    ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                    'flow_channels'
                )
                ->addColumn(
                    'meta_ref_id',
                    Table::TYPE_INTEGER,
                    '11',
                    [],
                    'meta_ref_id'
                )
                ->addColumn(
                    'meta_file',
                    Table::TYPE_INTEGER,
                    null,
                    [],
                    'meta_file'
                )
                ->addColumn(
                    'meta_processed',
                    Table::TYPE_INTEGER,
                    '1',
                    [],
                    'meta_processed'
                )
                ->addColumn(
                    'meta_insert_time',
                    Table::TYPE_DATETIME,
                    '10',
                    ['unsigned' => true, 'nullable' => false],
                    'meta_insert_time'
                )
                ->addColumn(
                    'meta_process_time',
                    Table::TYPE_DATETIME,
                    '10',
                    [],
                    'meta_process_time'
                );
            $installer->getConnection()->createTable($table_eavs);
        }

        /**
         * Create table 'flow_from_price' if not exists
         */
        if (!$installer->tableExists('flow_from_price')) {
            $table_price = $installer->getConnection()->newTable(
                $installer->getTable('flow_from_price')
            )
                ->addColumn(
                    'sku',
                    Table::TYPE_TEXT,
                    '60',
                    [],
                    'sku'
                )
                ->addColumn(
                    'paese',
                    Table::TYPE_TEXT,
                    '20',
                    [],
                    'paese'
                )
                ->addColumn(
                    'prezzo',
                    Table::TYPE_DECIMAL,
                    '12,4',
                    ['nullable' => false, 'default' => '0.0000'],
                    'prezzo'
                )
                ->addColumn(
                    'valuta',
                    Table::TYPE_TEXT,
                    '3',
                    [],
                    'valuta'
                )
                ->addColumn(
                    'meta_id',
                    Table::TYPE_INTEGER,
                    null,
                    ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                    'flow_channels'
                )
                ->addColumn(
                    'meta_ref_id',
                    Table::TYPE_INTEGER,
                    '11',
                    [],
                    'meta_ref_id'
                )
                ->addColumn(
                    'meta_file',
                    Table::TYPE_INTEGER,
                    null,
                    [],
                    'meta_file'
                )
                ->addColumn(
                    'meta_processed',
                    Table::TYPE_INTEGER,
                    '1',
                    [],
                    'meta_processed'
                )
                ->addColumn(
                    'meta_insert_time',
                    Table::TYPE_DATETIME,
                    '10',
                    ['unsigned' => true, 'nullable' => false],
                    'meta_insert_time'
                )
                ->addColumn(
                    'meta_process_time',
                    Table::TYPE_DATETIME,
                    '10',
                    [],
                    'meta_process_time'
                );

            $installer->getConnection()->createTable($table_price);
        }


        $this->createLogTable($installer);
        $this->installBundleTable($installer);

        $installer->endSetup();
    }


    /**
     * @param SchemaSetupInterface $installer
     * @throws Zend_Db_Exception
     */
    protected function createLogTable(SchemaSetupInterface $installer)
    {
        /**
         * Create table 'flow_log' if not exists
         */
        if ($installer->tableExists('flow_log')) {
            return;
        }

        $logTable = $installer->getConnection()->newTable(
            $installer->getTable('flow_log')
        )
            ->addColumn(
                'id',
                Table::TYPE_INTEGER,
                null,
                ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                'Flow log table'
            )
            ->addColumn(
                'message',
                Table::TYPE_TEXT,
                '1024',
                [],
                'Human readable message'
            )
            ->addColumn(
                'stack_trace',
                Table::TYPE_TEXT,
                '64k',
                [],
                'Stacktrace'
            )->addColumn(
                'stack_trace_hash',
                Table::TYPE_TEXT,
                '200',
                ['nullable' => false],
                'Stack Trace hash md5'
            )
            ->addColumn(
                'error_severity',
                Table::TYPE_TEXT,
                '200',
                ['nullable' => false],
                'Error severity'
            )
            ->addColumn(
                'error_repeat_count',
                Table::TYPE_INTEGER,
                null,
                ['unsigned' => true, 'nullable' => false, 'default' => 1],
                'Error repeat count'
            )
            ->addColumn(
                'meta_file',
                Table::TYPE_INTEGER,
                null,
                ['unsigned' => true, 'nullable' => true],
                'Inbound Flow file'
            )->addColumn(
                'meta_insert_time',
                Table::TYPE_DATETIME,
                '10',
                ['unsigned' => true, 'nullable' => false],
                'meta_insert_time'
            )
            ->addForeignKey(
                $installer->getFkName(
                    'flow_log',
                    'meta_file',
                    'flow_inboundflow',
                    'id'
                ),
                'meta_file',
                $installer->getTable('flow_inboundflow'),
                'id',
                Table::ACTION_CASCADE
            );

        $installer->getConnection()->createTable($logTable);
    }


    /**
     * @param SchemaSetupInterface $setup
     * @throws Zend_Db_Exception
     */
    public function installBundleTable(SchemaSetupInterface $setup)
    {
        /**
         * Create table 'flow_inboundflow' if not exists
         */
        if (!$setup->tableExists('flow_from_bundle')) {
            $table = $setup->getConnection()->newTable(
                $setup->getTable('flow_from_bundle')
            )
                ->addColumn(
                    'meta_id',
                    Table::TYPE_INTEGER,
                    null,
                    [
                        'identity' => true,
                        'unsigned' => true,
                        'nullable' => false,
                        'primary' => true
                    ],
                    'flow_from_bundle'
                )
                ->addColumn(
                    'meta_file',
                    Table::TYPE_INTEGER,
                    null,
                    ['unsigned' => true, 'nullable' => false],
                    'meta_file'
                )
                ->addColumn(
                    'bundle_sku',
                    Table::TYPE_TEXT,
                    '255',
                    [],
                    'bundle_sku'
                )
                ->addColumn(
                    'bundle_name',
                    Table::TYPE_TEXT,
                    '255',
                    [],
                    'bundle_name'
                )
                ->addColumn(
                    'simple_sku',
                    Table::TYPE_TEXT,
                    '255',
                    [],
                    'simple_sku'
                )
                ->addColumn(
                    'bundle_group_position',
                    Table::TYPE_INTEGER,
                    '11',
                    [],
                    'bundle_group_position'
                )
                ->addColumn(
                    'bundle_option_name',
                    Table::TYPE_TEXT,
                    '255',
                    [],
                    'bundle_option_name'
                )
                ->addColumn(
                    'bundle_type_option',
                    Table::TYPE_TEXT,
                    '255',
                    [],
                    'bundle_type_option'
                )
                ->addColumn(
                    'bundle_option_position',
                    Table::TYPE_INTEGER,
                    '11',
                    [],
                    'bundle_option_position'
                )
                ->addColumn(
                    'bundle_option_required',
                    Table::TYPE_TEXT,
                    '255',
                    [],
                    'bundle_option_required'
                )
                ->addColumn(
                    'bundle_option_default',
                    Table::TYPE_TEXT,
                    '255',
                    [],
                    'bundle_option_default'
                )
                ->addColumn(
                    'bundle_option_default_qty',
                    Table::TYPE_TEXT,
                    '255',
                    [],
                    'bundle_option_default_qty'
                )->addColumn(
                    'bundle_option_can_change_qty',
                    Table::TYPE_TEXT,
                    '255',
                    [],
                    'bundle_option_can_change_qty'
                )
                ->addColumn(
                    'bundle_price_view',
                    Table::TYPE_TEXT,
                    '255',
                    [],
                    'bundle_price_view'
                )
                ->addColumn(
                    'bundle_price_type',
                    Table::TYPE_TEXT,
                    '255',
                    [],
                    'bundle_price_type'
                )->addColumn(
                    'meta_processed',
                    Table::TYPE_INTEGER,
                    '1',
                    [],
                    'meta_processed'
                )
                ->addColumn(
                    'meta_insert_time',
                    Table::TYPE_DATETIME,
                    '10',
                    ['unsigned' => true, 'nullable' => false],
                    'meta_insert_time'
                )
                ->addColumn(
                    'meta_process_time',
                    Table::TYPE_DATETIME,
                    '10',
                    [],
                    'meta_process_time'
                )
                ->addIndex(
                    $setup->getIdxName('flow_from_bundle_meta_file', ['meta_file']),
                    ['meta_file']
                )
                ->addForeignKey(
                    $setup->getFkName(
                        'flow_from_bundle',
                        'meta_file',
                        'flow_inboundflow',
                        'id'
                    ),
                    'meta_file',
                    $setup->getTable('flow_inboundflow'),
                    'id',
                    Table::ACTION_CASCADE
                );

            $setup->getConnection()->createTable($table);
        }
    }
}
