<?php
declare(strict_types=1);

namespace FiloBlu\Flow\Model\Filters;

/**
 * Class SubString
 * @package FiloBlu\Flow\Model\Filters
 */
class SubString extends AbstractFilter
{

    /**
     * @param $value
     * @param $args
     * @return false|string
     */
    public function filter($value, $args)
    {
        $v = trim($value ?? '');

        if ($args && isset($args['offset']) && count($args)) {
            $intArgs = array_map(function($a) { return (int)$a; }, $args);
            if (!isset($intArgs['length'])) {
                return substr($v, $intArgs['offset']);
            }

            return substr($v, $intArgs['offset'], $intArgs['length']);
        }

        return $v;
    }
}
