<?php

namespace FiloBlu\Flow\Model\Connector;

use FiloBlu\Flow\Helper\LoggerProvider;
use Monolog\Logger;

/**
 * Class AbstractConnector
 * @package FiloBlu\Flow\Model\Connector
 */
abstract class AbstractConnector
{

    /**
     * @var string
     */
    protected $_mask;

    /**
     * @var
     */
    protected $_config;

    /**
     * @var Logger
     */
    protected $_logger;

    /**
     * @var
     */
    protected $connection;

    /**
     * AbstractConnector constructor.
     * @param LoggerProvider $loggerProvider
     */
    public function __construct(LoggerProvider $loggerProvider)
    {
        $this->_logger = $loggerProvider->getLogger();
    }

    /**
     * @return mixed
     */
    public function getResources()
    {

    }

    /**
     * @return mixed
     */
    public function getConnection()
    {

    }

    /**
     * @param $mask
     */
    public function setMask($mask)
    {
        $this->_mask = $mask;
    }

    /**
     * @return mixed
     */
    public function getConfig()
    {
        return $this->_config;
    }

    /**
     * @param $config
     */
    public function setConfig($config)
    {
        $this->_config = $config;
    }

    /**
     * @return mixed
     */
    protected function fetchResources()
    {

    }

    /**
     *
     */
    protected function init()
    {

    }
}
