<?php
/**
 * Copyright © 2015 FiloBlu . All rights reserved.
 * Author: Raffaele Pugliese
 */

namespace FiloBlu\Flow\Helper;

use Magento\Company\Api\CompanyManagementInterface;
use Magento\Company\Api\CompanyRepositoryInterface;
use Magento\Company\Api\Data\CompanyInterface;
use Magento\Framework\Api\DataObjectHelper;
use Magento\Framework\App\Area;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Module\Manager;
use Magento\Framework\ObjectManagerInterface;
use Magento\Store\Model\App\Emulation;
use Magento\Store\Model\StoreManagerInterface;

/**
 * Class CustomerHelper
 * @package FiloBlu\Flow\Helper
 */
class CustomerHelper extends AbstractHelper
{
    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;
    /**
     * @var ObjectManagerInterface
     */
    protected $objectManager;
    /**
     * @var CompanyRepositoryInterface
     */
    protected $companyRepository;

    /**
     * @var DataObjectHelper
     */
    protected $dataObjectHelper;
    /**
     * @var CompanyManagementInterface
     */
    protected $companyManagement;
    /**
     * @var \Magento\Framework\Module\Manager
     */
    private $manager;
    /**
     * @var \Magento\Store\Model\App\Emulation
     */
    private $emulation;


    /**
     * @param \Magento\Framework\App\Helper\Context $context
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     * @param \Magento\Framework\Api\DataObjectHelper $dataObjectHelper
     * @param \Magento\Framework\Module\Manager $manager
     * @param \Magento\Store\Model\App\Emulation $emulation
     */
    public function __construct(
        Context $context,
        StoreManagerInterface $storeManager,
        ObjectManagerInterface $objectManager,
        DataObjectHelper $dataObjectHelper,
        Manager $manager,
        Emulation $emulation
    ) {
        parent::__construct($context);
        $this->storeManager = $storeManager;
        $this->objectManager = $objectManager;
        $this->dataObjectHelper = $dataObjectHelper;
        $this->manager = $manager;
        $this->emulation = $emulation;
    }

    /**
     * @param $companyData
     * @return bool
     */
    public function addCompanyToCustomer($companyData)
    {
        if (!$this->manager->isEnabled('Magento_Company')) {
            return false;
        }

        if (!count($companyData)) {
            return false;
        }


        $company = $this->objectManager->create(CompanyInterface::class);

        $this->dataObjectHelper->populateWithArray(
            $company,
            $companyData,
            CompanyInterface::class
        );

        $this->emulation->startEnvironmentEmulation(
            $this->storeManager->getDefaultStoreView()->getId(),
            Area::AREA_ADMINHTML,
            true
        );
        $this->getCompanyRepository()->save($company);
        $this->emulation->stopEnvironmentEmulation();

        return true;
    }

    /**
     * @return \Magento\Company\Api\CompanyRepositoryInterface
     */
    public function getCompanyRepository()
    {
        if ($this->companyRepository === null) {
            $this->companyRepository = $this->objectManager->create(
                CompanyRepositoryInterface ::class
            );
        }

        return $this->companyRepository;
    }

    /**
     * @param $customerId
     * @return bool
     */
    public function companyExist($customerId)
    {
        if (!$this->manager->isEnabled('Magento_Company') || !$customerId) {
            return false;
        }

        $company = $this->getCompanyManagement()->getByCustomerId($customerId);

        if (!$company) {
            return false;
        }

        return true;
    }

    /**
     * @return \Magento\Company\Api\CompanyManagementInterface
     */
    public function getCompanyManagement()
    {
        if ($this->companyManagement === null) {
            $this->companyManagement = $this->objectManager->create(CompanyManagementInterface::class);
        }

        return $this->companyManagement;
    }
}
