<?php

namespace FiloBlu\Flow\Controller\Adminhtml\Channel;

use FiloBlu\Flow\Model\Channel;
use FiloBlu\Flow\Model\Channel\Config;
use Magento\Backend\App\Action;
use Magento\Backend\Model\Session;
use Magento\Framework\Registry;
use Magento\Framework\View\Result\PageFactory;

/**
 * Class Edit
 * @package FiloBlu\Flow\Controller\Adminhtml\Channel
 */
class Edit extends Action
{
    /**
     * @return \Magento\Framework\App\ResponseInterface
     */
    public function execute()
    {

        // 1. Get ID and create model
        $id = $this->getRequest()->getParam('id');

        $model = $this->_objectManager->create(Channel::class, [
            'data' => [
                'type' => 'in',
                'use_map' => '0',
                'config' => [
                    'copy_to_ite' => '0',
                    'concurrency' => '1',
                    'bus' => '1',
                    'priority' => 'low',
                    'type' => 'file',
                    'preorder_discard' => '0',
                    'strip_white_space' => '1',
                    'kill_after' => Config::DEFAULT_KILL_AFTER_MINUTES
                ],
                'connector' => [
                    'type' => 'ftp',
                    'passive' => '1',
                    'ftp_dir' => '/IN_LOCAL',
                    'local_dir' => 'common/bouncer'
                ],
                'parser' => [
                    'type' => 'csv',
                    'separator' => ';',
                    'delimiter' => '"',
                    'lines_to_skip' => '1'
                ]
            ]]);

        $registryObject = $this->_objectManager->get(Registry::class);

        // 2. Initial checking
        if ($id) {
            $model->load($id);
            if (!$model->getId()) {
                $this->messageManager->addErrorMessage(__('This row no longer exists.'));
                return $this->_redirect('*/*/');
            }
        }
        // 3. Set entered data if was error when we do save
        $data = $this->_objectManager->get(Session::class)->getFormData(true);

        if (!empty($data)) {
            $model->setData($data);
        }

        // 4. set defaults
        $this->setDefaultsForMissingFields($model);
        $registryObject->register('flow_channel', $model);
        $this->_view->loadLayout();
        $this->_view->getLayout()->initMessages();
        $this->_view->renderLayout();
    }

    /**
     * @param $model
     * @return mixed
     */
    public function setDefaultsForMissingFields($model)
    {
        $data = $model->getData();

        //Config default setting
        if (!isset($data['config']['strip_white_space'])) {
            $data['config']['strip_white_space'] = '1';
        }

        if (!isset($data['config']['concurrency'])) {
            $data['config']['concurrency'] = '1';
        }

        if (!isset($data['config']['bus'])) {
            $data['config']['bus'] = '1';
        }

        if (!isset($data['config']['priority'])) {
            $data['config']['priority'] = 'low';
        }

        if (!isset($data['config']['type'])) {
            $data['config']['type'] = 'file';
        }

        if (!isset($data['config']['preorder_discard'])) {
            $data['config']['preorder_discard'] = '0';
        }

        if (!isset($data['config']['strip_white_space'])) {
            $data['config']['strip_white_space'] = '1';
        }

        if (!isset($data['config']['kill_after'])) {
            $data['config']['kill_after'] = Config::DEFAULT_KILL_AFTER_MINUTES;
        }

        //connector default setting
        if (!isset($data['connector']['type'])) {
            $data['connector']['type'] = 'ftp';
        }

        if (!isset($data['connector']['passive'])) {
            $data['connector']['passive'] = '1';
        }

        if (!isset($data['connector']['ftp_dir'])) {
            $data['connector']['ftp_dir'] = '/IN_LOCAL';
        }

        if (!isset($data['connector']['local_dir'])) {
            $data['connector']['local_dir'] = 'common/bouncer';
        }

        //Parser default setting
        if (!isset($data['parser']['type'])) {
            $data['parser']['type'] = 'csv';
        }

        if (!isset($data['parser']['separator'])) {
            $data['parser']['separator'] = ';';
        }

        if (!isset($data['parser']['delimiter'])) {
            $data['parser']['delimiter'] = '"';
        }

        if (!isset($data['parser']['lines_to_skip'])) {
            $data['parser']['lines_to_skip'] = '1';
        }

        $model->setData($data);
        return $model;
    }
}
