<?php

namespace FiloBlu\Flow\Block\Adminhtml\Inboundflow\Edit;

use Magento\Framework\App\ObjectManager;

/**
 * Class Tabs
 * @package FiloBlu\Flow\Block\Adminhtml\Inboundflow\Edit
 */
class Tabs extends \Magento\Backend\Block\Widget\Tabs
{
    /**
     *
     */
    protected function _construct()
    {
        parent::_construct();
        $this->setId('checkmodule_inboundflow_tabs');
        $this->setDestElementId('edit_form');
        $this->setTitle(__('Inboundflow Information'));
    }

    /**
     * @return $this
     * @throws \Exception
     */
    protected function _beforeToHtml()
    {
        $reg = ObjectManager::getInstance()->get('\Magento\Framework\Registry');
        $data = $reg->registry('flow_inboundflow');

        $this->addTab(
            'flow_inboundflow_edit_tab_flow',
            [
                'label' => __('Flow'),
                'title' => __('Flow'),
                'url' => $this->getUrl('*/*/grid', ['id' => (int)$this->getRequest()->getParam('id', 0), 'flow' => urlencode($data->getData('flow') ??'')]),
                'class' => 'ajax',
                'active' => false
            ]
        );
        return parent::_beforeToHtml();
    }
}
