<?php

namespace FiloBlu\Flow\Model\Indexer\Plugin;

use FiloBlu\Flow\Model\Indexer\Stock;
use Magento\Framework\Module\Manager;
use Magento\Indexer\Model\Config\Data;

/**
 *
 */
class IndexerConfigData
{
    /**
     * @var Manager
     */
    private $manager;

    public function __construct(Manager $manager)
    {
        $this->manager = $manager;
    }

    /**
     *
     *
     * @param Data $subject
     * @param array|mixed|null $data
     * @param string $path
     * @param mixed $default
     *
     * @return mixed
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGet(
        Data $subject,
        $data,
        $path = null,
        $default = null
    ) {
        if (!$this->manager->isEnabled('Magento_Inventory')) {
            $this->processData(Stock::INDEXER_ID, $path, $default, $data);
        }

        return $data;
    }

    /**
     * @param int $indexerId
     * @param string $path
     * @param mixed $default
     * @param mixed $data
     * @return void
     */
    protected function processData($indexerId, $path, $default, &$data)
    {
        if (!$path && isset($data[$indexerId])) {
            unset($data[$indexerId]);
        } elseif ($path) {
            list($firstKey, ) = explode('/', $path);
            if ($firstKey == $indexerId) {
                $data = $default;
            }
        }
    }
}
