<?php

namespace FiloBlu\Inboundflow\Controller\Adminhtml\Inboundflow;
use Exception;
use Magento\Backend\App\Action;
use Magento\Framework\View\Result\PageFactory;

/**
 * Class MassStatus
 * @package FiloBlu\Inboundflow\Controller\Adminhtml\Inboundflow
 */
class MassStatus extends Action
{
    /**
     * @var PageFactory
     */
    public function execute()
    {
        $ids = $this->getRequest()->getParam('id');
        $status = $this->getRequest()->getParam('status');
        if (!is_array($ids) || empty($ids)) {
            $this->messageManager->addError(__('Please select product(s).'));
        } else {
            try {
                foreach ($ids as $id) {
                    $row = $this->_objectManager->get('FiloBlu\Firstgrid\Model\Inboundflow')->load($id);
                    $row->setData('status', $status)
                        ->save();
                }
                $this->messageManager->addSuccess(
                    __('A total of %1 record(s) have been deleted.', count($ids))
                );
            } catch (Exception $e) {
                $this->messageManager->addError($e->getMessage());
            }
        }
        $this->_redirect('*/*/');
    }
}
